/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.constant;

import com.google.common.reflect.TypeToken;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4050;
import net.minecraft.class_572;
import net.minecraft.class_811;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animation.state.ControllerState;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;

public final class DataTickets {
    private static final Map<String, SerializableDataTicket<?>> SERIALIZABLE_TICKETS = new ConcurrentHashMap();
    public static final DataTicket<Double> TICK = DataTicket.create("tick", Double.class, new TypeToken<Double>(){});
    public static final DataTicket<Class> ANIMATABLE_CLASS = DataTicket.create("animatable_class", Class.class, new TypeToken<Class>(){});
    public static final DataTicket<Float> PARTIAL_TICK = DataTicket.create("partial_tick", Float.class, new TypeToken<Float>(){});
    public static final DataTicket<Integer> RENDER_COLOR = DataTicket.create("render_color", Integer.class, new TypeToken<Integer>(){});
    public static final DataTicket<Long> ANIMATABLE_INSTANCE_ID = DataTicket.create("animatable_instance_id", Long.class, new TypeToken<Long>(){});
    public static final DataTicket<Boolean> INVISIBLE_TO_PLAYER = DataTicket.create("invisible_to_player", Boolean.class, new TypeToken<Boolean>(){});
    public static final DataTicket<Integer> PACKED_OVERLAY = DataTicket.create("packed_overlay", Integer.class, new TypeToken<Integer>(){});
    public static final DataTicket<Integer> PACKED_LIGHT = DataTicket.create("packed_light", Integer.class, new TypeToken<Integer>(){});
    public static final DataTicket<Integer> GLOW_COLOUR = DataTicket.create("glow_colour", Integer.class, new TypeToken<Integer>(){});
    public static final DataTicket<Boolean> IS_SHAKING = DataTicket.create("is_shaking", Boolean.class, new TypeToken<Boolean>(){});
    public static final DataTicket<class_4050> ENTITY_POSE = DataTicket.create("entity_pose", class_4050.class, new TypeToken<class_4050>(){});
    public static final DataTicket<Float> ENTITY_PITCH = DataTicket.create("entity_pitch", Float.class, new TypeToken<Float>(){});
    public static final DataTicket<Float> ENTITY_YAW = DataTicket.create("entity_yaw", Float.class, new TypeToken<Float>(){});
    public static final DataTicket<Float> ENTITY_BODY_YAW = DataTicket.create("entity_body_yaw", Float.class, new TypeToken<Float>(){});
    public static final DataTicket<class_243> VELOCITY = DataTicket.create("velocity", class_243.class, new TypeToken<class_243>(){});
    public static final DataTicket<Boolean> IS_MOVING = DataTicket.create("is_moving", Boolean.class, new TypeToken<Boolean>(){});
    public static final DataTicket<class_2680> BLOCKSTATE = DataTicket.create("blockstate", class_2680.class, new TypeToken<class_2680>(){});
    public static final DataTicket<class_243> POSITION = DataTicket.create("position", class_243.class, new TypeToken<class_243>(){});
    public static final DataTicket<class_2338> BLOCKPOS = DataTicket.create("blockpos", class_2338.class, new TypeToken<class_2338>(){});
    public static final DataTicket<class_2350> BLOCK_FACING = DataTicket.create("block_facing", class_2350.class, new TypeToken<class_2350>(){});
    public static final DataTicket<class_811> ITEM_RENDER_PERSPECTIVE = DataTicket.create("item_render_perspective", class_811.class, new TypeToken<class_811>(){});
    public static final DataTicket<Boolean> HAS_GLINT = DataTicket.create("has_glint", Boolean.class, new TypeToken<Boolean>(){});
    public static final DataTicket<class_1792> ITEM = DataTicket.create("item", class_1792.class, new TypeToken<class_1792>(){});
    public static final DataTicket<AnimatableManager> ANIMATABLE_MANAGER = DataTicket.create("animatable_manager", AnimatableManager.class, new TypeToken<AnimatableManager>(){});
    public static final DataTicket<Boolean> SWINGING_ARM = DataTicket.create("swinging_arm", Boolean.class, new TypeToken<Boolean>(){});
    public static final DataTicket<Boolean> SPRINTING = DataTicket.create("sprinting", Boolean.class, new TypeToken<Boolean>(){});
    public static final DataTicket<Boolean> IS_DEAD_OR_DYING = DataTicket.create("is_dead_or_dying", Boolean.class, new TypeToken<Boolean>(){});
    public static final DataTicket<Boolean> IS_ENCHANTED = DataTicket.create("is_enchanted", Boolean.class, new TypeToken<Boolean>(){});
    public static final DataTicket<Boolean> IS_STACKABLE = DataTicket.create("is_stackable", Boolean.class, new TypeToken<Boolean>(){});
    public static final DataTicket<Integer> MAX_USE_DURATION = DataTicket.create("max_use_duration", Integer.class, new TypeToken<Integer>(){});
    public static final DataTicket<Integer> MAX_DURABILITY = DataTicket.create("max_durability", Integer.class, new TypeToken<Integer>(){});
    public static final DataTicket<Integer> REMAINING_DURABILITY = DataTicket.create("remaining_durability", Integer.class, new TypeToken<Integer>(){});
    public static final DataTicket<class_1304> EQUIPMENT_SLOT = DataTicket.create("equipment_slot", class_1304.class, new TypeToken<class_1304>(){});
    public static final DataTicket<class_572> HUMANOID_MODEL = DataTicket.create("humanoid_model", class_572.class, new TypeToken<class_572>(){});
    public static final DataTicket<Boolean> IS_GECKOLIB_WEARER = DataTicket.create("is_geckolib_wearer", Boolean.class, new TypeToken<Boolean>(){});
    public static final DataTicket<EnumMap> EQUIPMENT_BY_SLOT = DataTicket.create("equipment_by_slot", EnumMap.class, new TypeToken<EnumMap>(){});
    public static final DataTicket<Boolean> IS_LEFT_HANDED = DataTicket.create("is_left_handed", Boolean.class, new TypeToken<Boolean>(){});
    public static final DataTicket<Boolean> IS_CROUCHING = DataTicket.create("is_crouching", Boolean.class, new TypeToken<Boolean>(){});
    public static final DataTicket<class_243> ELYTRA_ROTATION = DataTicket.create("elytra_rotation", class_243.class, new TypeToken<class_243>(){});
    @ApiStatus.Internal
    public static final DataTicket<EnumMap> PER_SLOT_RENDER_DATA = DataTicket.create("per_slot_render_data", EnumMap.class, new TypeToken<EnumMap>(){});
    @ApiStatus.Internal
    public static final DataTicket<ControllerState[]> ANIMATION_CONTROLLER_STATES = DataTicket.create("animation_controller_states", ControllerState[].class, new TypeToken<ControllerState[]>(){});
    public static final SerializableDataTicket<Integer> ANIM_STATE = SerializableDataTicket.ofInt(GeckoLibConstants.id("anim_state"));
    public static final SerializableDataTicket<String> ANIM = SerializableDataTicket.ofString(GeckoLibConstants.id("anim"));
    public static final SerializableDataTicket<Integer> USE_TICKS = SerializableDataTicket.ofInt(GeckoLibConstants.id("use_ticks"));
    public static final SerializableDataTicket<Boolean> ACTIVE = SerializableDataTicket.ofBoolean(GeckoLibConstants.id("active"));
    public static final SerializableDataTicket<Boolean> OPEN = SerializableDataTicket.ofBoolean(GeckoLibConstants.id("open"));
    public static final SerializableDataTicket<Boolean> CLOSED = SerializableDataTicket.ofBoolean(GeckoLibConstants.id("closed"));
    public static final SerializableDataTicket<class_2350> DIRECTION = SerializableDataTicket.ofEnum(GeckoLibConstants.id("direction"), class_2350.class);

    public static @Nullable SerializableDataTicket<?> byName(class_2960 id) {
        return SERIALIZABLE_TICKETS.getOrDefault(id.toString(), null);
    }

    @ApiStatus.Internal
    public static <D> SerializableDataTicket<D> registerSerializable(SerializableDataTicket<D> ticket) {
        SerializableDataTicket<D> existingTicket = SERIALIZABLE_TICKETS.putIfAbsent(ticket.id(), ticket);
        if (existingTicket != null) {
            GeckoLibConstants.LOGGER.error("Duplicate SerializableDataTicket registered! This will cause issues. Existing: {}, New: {}", (Object)existingTicket.id(), (Object)ticket.id());
        }
        return ticket;
    }
}

